# Read input
n = int(input())

# Generate primes up to 10^5 using sieve
isprime = [True] * 100000
isprime[0] = False
isprime[1] = False
for i in range(100000):
    if isprime[i]:
        # sieve out all multiples
        for d in range(2, (99999 // i) + 1):
            isprime[d * i] = False
            
# Check each prime and its complement instead of all pairs of primes
# Faster would be to enumerate primes from both directions, but not needed
for a in range(2, n):
    if isprime[a] and isprime[n-a]:
        print(a, n-a)
        break
